/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.websm.updates;

import com.ibm.hsc.common.exceptions.PIHscClientException;
import com.ibm.hsc.websm.updates.PIFlashLID;
import com.ibm.hsc.websm.updates.PIUpdateDefines;
import com.ibm.hsc.websm.updates.PIUpdateErrorIds;
import com.ibm.hsc.websm.updates.PIUpdateException;
import com.ibm.hsc.websm.updates.TargettedFsp;
import com.ibm.hwmca.base.updates.UpdateUtilities;
import com.ibm.hwmca.base.util.BaseFileControl;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.util.BinaryNumber;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Vector;
import org.snia.wbem.cim.UnsignedInt16;
import org.snia.wbem.cim.UnsignedInt32;
import org.snia.wbem.cim.UnsignedInt8;

public class CommonMarkerLID
extends PIFlashLID
implements PIUpdateErrorIds,
PIUpdateDefines {
    private static final String TRACE_MASKT = "XUPDMRKT";
    private static final String TRACE_MASKF = "XUPDMRKF";
    private static final String TRACE_MASKD = "XUPDMRKD";
    private static final int MARKER_LID_LENGTH = 80;
    private String dataArea;
    private int lidHeaderLength;
    private static Integer lidLock = new Integer(0);
    private byte[] markerLID;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommonMarkerLID(TargettedFsp targettedFsp, boolean bl) throws HException {
        Trace.trace((String)TRACE_MASKT, (Object)"-> CommonMarkerLid()");
        Vector<UnsignedInt16> vector = new Vector<UnsignedInt16>();
        vector.add(new UnsignedInt16(1));
        Vector<UnsignedInt8> vector2 = new Vector<UnsignedInt8>();
        if (bl) {
            vector2.add(new UnsignedInt8(1));
        } else {
            vector2.add(new UnsignedInt8(0));
        }
        try {
            this.dataArea = BaseFileControl.getFilePath((String)"iqzmsupd.dat");
        }
        catch (HException hException) {
            Trace.trace((String)TRACE_MASKF, (Object)("Failed to set up data area " + (Object)((Object)hException)));
            PIUpdateException pIUpdateException = new PIUpdateException(-2014, hException);
            throw pIUpdateException;
        }
        Vector<String> vector3 = new Vector<String>();
        String string = this.dataArea + "marker.lid";
        vector3.add(string);
        Vector<UnsignedInt32> vector4 = new Vector<UnsignedInt32>();
        vector4.add(new UnsignedInt32(0L));
        UnsignedInt32 unsignedInt32 = new UnsignedInt32(188L);
        Vector<UnsignedInt32> vector5 = new Vector<UnsignedInt32>();
        vector5.add(unsignedInt32);
        Integer n = lidLock;
        synchronized (n) {
            File file = new File(string);
            if (file.exists()) {
                Trace.trace((String)TRACE_MASKD, (Object)"Deleting the common marker LID file.");
                file.delete();
            }
            try {
                Trace.trace((String)TRACE_MASKF, (Object)("Calling readSpecialLID lidNumber=" + vector + " side=" + vector2));
                Trace.trace((String)TRACE_MASKF, (Object)("fileName=[" + vector3 + "] offset=" + vector4 + " lengthToRead=" + vector5));
                targettedFsp.readSpecialLID("master", vector, vector2, vector3, vector4, vector5);
            }
            catch (PIHscClientException pIHscClientException) {
                Trace.trace((String)TRACE_MASKF, (Object)("Failed pulling marker LID from flash " + pIHscClientException));
                LocalizableText[] localizableTextArray = new LocalizableText[]{new LocalizableText(targettedFsp.getMTMS())};
                PIUpdateException pIUpdateException = new PIUpdateException(-2016, pIHscClientException, localizableTextArray);
                throw pIUpdateException;
            }
            super.initAsFile(file);
            this.readFile(file);
        }
        Trace.trace((String)TRACE_MASKT, (Object)"<- CommonMarkerLid()");
    }

    public CommonMarkerLID(File file) throws HException {
        super(file);
        Trace.trace((String)TRACE_MASKT, (Object)"-> CommonMarkerLid()");
        this.readFile(file);
        Trace.trace((String)TRACE_MASKT, (Object)"<- CommonMarkerLid()");
    }

    public int getLastDifferentFSPLevel() {
        Trace.trace((String)TRACE_MASKT, (Object)"-> getLastDifferentFSPLevel()");
        String string = new String(this.markerLID, this.getIndexPastMIOffset() + 12, 3);
        int n = Integer.parseInt(string);
        Trace.trace((String)TRACE_MASKD, (Object)("level=" + n));
        Trace.trace((String)TRACE_MASKT, (Object)"<- getLastDifferentFSPLevel()");
        return n;
    }

    public int getLastDifferentPHYPLevel() {
        Trace.trace((String)TRACE_MASKT, (Object)"-> getLastDifferentPHYPLevel()");
        String string = new String(this.markerLID, this.getIndexPastMIOffset() + 15, 3);
        int n = Integer.parseInt(string);
        Trace.trace((String)TRACE_MASKD, (Object)("level=" + n));
        Trace.trace((String)TRACE_MASKT, (Object)"<- getLastDifferentPHYPLevel()");
        return n;
    }

    public int getLastDifferentPartitionFirmwareLevel() {
        Trace.trace((String)TRACE_MASKT, (Object)"-> getLastDifferentPartitionFirmwareLevel()");
        String string = new String(this.markerLID, this.getIndexPastMIOffset() + 18, 3);
        int n = Integer.parseInt(string);
        Trace.trace((String)TRACE_MASKD, (Object)("level=" + n));
        Trace.trace((String)TRACE_MASKT, (Object)"<- getLastDifferentPartitionFirmwareLevel()");
        return n;
    }

    public int getLastDisruptivePHYPLevel() {
        Trace.trace((String)TRACE_MASKT, (Object)"-> getLastDisruptivePHYPLevel()");
        int n = 999;
        try {
            String string = new String(this.markerLID, this.getIndexPastMIOffset() + 6, 3);
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            Trace.trace((String)TRACE_MASKF, (Object)("Caught exception trying to get disruptive PHYP level " + exception));
        }
        Trace.trace((String)TRACE_MASKD, (Object)("level=" + n));
        Trace.trace((String)TRACE_MASKT, (Object)"<- getLastDisruptivePHYPLevel()");
        return n;
    }

    public int getLevel() {
        Trace.trace((String)TRACE_MASKT, (Object)"-> getLevel()");
        String string = new String(this.markerLID, this.getMIOffset() + 6, 3);
        int n = Integer.parseInt(string);
        Trace.trace((String)TRACE_MASKD, (Object)("level=" + n));
        Trace.trace((String)TRACE_MASKT, (Object)"<- getLevel()");
        return n;
    }

    public int getMIOffset() {
        Trace.trace((String)TRACE_MASKT, (Object)"-> getMIOffset()");
        int n = 4 + this.getOffsetOfMISection();
        Trace.trace((String)TRACE_MASKD, (Object)("MIOffset=" + n));
        Trace.trace((String)TRACE_MASKT, (Object)"<- getMIOffset");
        return n;
    }

    public String getPlatformID() {
        Trace.trace((String)TRACE_MASKT, (Object)"-> getPlatformID()");
        byte[] byArray = new byte[2];
        System.arraycopy(this.markerLID, this.getMIOffset(), byArray, 0, 2);
        String string = new String(byArray);
        Trace.trace((String)TRACE_MASKD, (Object)("platformId=" + string));
        Trace.trace((String)TRACE_MASKT, (Object)"<- getPlatformID()");
        return string;
    }

    public String getServicePackID() {
        Trace.trace((String)TRACE_MASKT, (Object)"-> getServicePackID()");
        byte[] byArray = new byte[3];
        System.arraycopy(this.markerLID, this.getMIOffset() + 2, byArray, 0, 3);
        String string = new String(byArray);
        Trace.trace((String)TRACE_MASKD, (Object)("servicePackId=" + string));
        Trace.trace((String)TRACE_MASKT, (Object)"<- getServicePackID()");
        return string;
    }

    private int getIndexPastMIOffset() {
        Trace.trace((String)TRACE_MASKT, (Object)"-> getIndexPastMIOffset()");
        int n = this.getMIOffsetSize() + this.getMIOffset();
        Trace.trace((String)TRACE_MASKD, (Object)("index=" + n));
        Trace.trace((String)TRACE_MASKT, (Object)"<- getIndexPastMIOffset");
        return n;
    }

    private int getMIOffsetSize() {
        Trace.trace((String)TRACE_MASKT, (Object)"-> getMIOffsetSize()");
        byte[] byArray = new byte[4];
        System.arraycopy(this.markerLID, this.getOffsetOfMISection(), byArray, 0, 4);
        int n = BinaryNumber.toInt((byte[])byArray);
        Trace.trace((String)TRACE_MASKD, (Object)("MIOffsetSize=" + n));
        Trace.trace((String)TRACE_MASKT, (Object)"<- getMIOffsetSize");
        return n;
    }

    private int getOffsetOfMISection() {
        Trace.trace((String)TRACE_MASKT, (Object)"-> getOffsetOfMISection()");
        byte[] byArray = new byte[4];
        System.arraycopy(this.markerLID, 4 + this.lidHeaderLength, byArray, 0, 4);
        int n = BinaryNumber.toInt((byte[])byArray);
        Trace.trace((String)TRACE_MASKD, (Object)("offset within marker LID=" + n));
        Trace.trace((String)TRACE_MASKD, (Object)("offset within LID=" + (n += this.lidHeaderLength)));
        Trace.trace((String)TRACE_MASKT, (Object)"<- getOffsetOfMISection()");
        return n;
    }

    private void readFile(File file) throws HException {
        Trace.trace((String)TRACE_MASKD, (Object)"-> readFile()");
        int n = (int)file.length();
        Trace.trace((String)TRACE_MASKD, (Object)("Length of marker lid [" + file.getName() + "] =" + n));
        this.markerLID = new byte[n];
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream, n);
            UpdateUtilities.readFully((BufferedInputStream)bufferedInputStream, (byte[])this.markerLID);
            Trace.trace((String)TRACE_MASKF, (Object)("Read MarkerLID [" + this.markerLID + "]"));
        }
        catch (IOException iOException) {
            Trace.trace((String)TRACE_MASKF, (Object)("I/O exception reading Common Marker LID " + iOException));
            PIUpdateException pIUpdateException = new PIUpdateException(-2015, iOException);
            throw pIUpdateException;
        }
        this.lidHeaderLength = super.getHeaderLength();
        Trace.trace((String)TRACE_MASKD, (Object)"<- readFile()");
    }
}

